/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWRouteListCellRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWRoutePropPanel
extends JPanel
implements ActionListener,
ItemListener,
ItemSelectable {
    private Frame m_parentFrame = null;
    private VWTrkDataModel m_trackerDataModel = null;
    private VWTrkMap m_selectedMap = null;
    private VWRouteDefinition m_selectedRoute = null;
    private Vector m_selectedRoutes = null;
    private int m_selectedRouteIndex = 0;
    private JComboBox m_nameComboBox = null;
    private VWRouteListCellRenderer m_routeListCellRenderer = null;
    private boolean m_bInitRouteData = false;
    private JTextArea m_expressionTextArea = null;
    private ItemListener m_selectListeners = null;
    private boolean m_bNotify = false;

    public VWRoutePropPanel(Frame parentFrame, VWTrkDataModel trackerDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = trackerDataModel;
        this.setupLayout();
    }

    public void initialize() {
        this.initData();
        this.updateLayout();
        this.selectRoute(null, false);
    }

    public void actionPerformed(ActionEvent event) {
        VWRouteDefinition routeDefinition = null;
        if (event.getSource().equals(this.m_nameComboBox)) {
            routeDefinition = (VWRouteDefinition)this.m_nameComboBox.getSelectedItem();
            if (routeDefinition == this.m_selectedRoute) {
                return;
            }
            this.selectRoute(this.m_selectedRoute, true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int routeCount;
        if (e.getID() == 100) {
            this.initData();
        }
        ItemSelectable itemSelectable = e.getItemSelectable();
        Object[] objects = itemSelectable.getSelectedObjects();
        this.m_selectedRoutes = new Vector();
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null || !(objects[i] instanceof VWRouteDefinition)) continue;
                this.m_selectedRoutes.addElement(objects[i]);
            }
        }
        if ((routeCount = this.m_selectedRoutes.size()) == 1) {
            this.selectRoute((VWRouteDefinition)this.m_selectedRoutes.elementAt(0), false);
        } else {
            this.selectRoute(null, false);
            this.setSelectedIndexNoNotify(-1);
        }
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    public Object[] getSelectedObjects() {
        Object[] objects = null;
        if (this.m_selectedRoute != null) {
            objects = new Object[]{this.m_selectedRoute};
        }
        return objects;
    }

    private void setupLayout() {
        Object gbCons = null;
        try {
            JPanel namePanel = new JPanel();
            namePanel.setLayout(new BorderLayout(4, 0));
            namePanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_name)), "Before");
            this.m_nameComboBox = new JComboBox(new DefaultComboBoxModel());
            this.m_nameComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    VWRouteDefinition route;
                    if (VWRoutePropPanel.this.m_bInitRouteData) {
                        return;
                    }
                    Object obj = VWRoutePropPanel.this.m_nameComboBox.getSelectedItem();
                    if (obj == null && VWRoutePropPanel.this.m_selectedRoute != null) {
                        VWRoutePropPanel.this.selectRoute(null, VWRoutePropPanel.this.m_bNotify);
                    } else if (obj instanceof VWRouteDefinition && (route = (VWRouteDefinition)obj) != VWRoutePropPanel.this.m_selectedRoute) {
                        VWRoutePropPanel.this.selectRoute(route, VWRoutePropPanel.this.m_bNotify);
                    }
                }
            });
            this.m_routeListCellRenderer = new VWRouteListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                    Component component = super.getListCellRendererComponent(list, value, index, isSelected, hasFocus);
                    if (value == null) {
                        ((JLabel)component).setText(VWResource.s_noOrMultiRoutesSelected);
                    }
                    return component;
                }
            };
            this.m_nameComboBox.setRenderer(this.m_routeListCellRenderer);
            namePanel.add((Component)this.m_nameComboBox, "Center");
            JPanel expressionPanel = new JPanel();
            expressionPanel.setLayout(new BorderLayout());
            expressionPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_expression)), "First");
            this.m_expressionTextArea = new JTextArea();
            this.m_expressionTextArea.setLineWrap(true);
            this.m_expressionTextArea.setWrapStyleWord(true);
            this.m_expressionTextArea.setRows(5);
            this.m_expressionTextArea.setEditable(false);
            expressionPanel.add((Component)new JScrollPane(this.m_expressionTextArea), "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)namePanel, "First");
            this.add((Component)expressionPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData() {
        Object vwWorkflowDef = null;
        VWMapDefinition vwMapDef = null;
        VWMapNode[] vwMapNodes = null;
        Object vwRoutes = null;
        VWMapNode vwMapNode = null;
        try {
            this.m_bInitRouteData = true;
            this.m_selectedRoute = null;
            if (this.m_trackerDataModel == null) {
                return;
            }
            VWTrkMap currentMap = this.m_selectedMap;
            this.m_selectedMap = this.m_trackerDataModel.getSelectedMap();
            if (this.m_selectedMap == currentMap) {
                return;
            }
            this.addRoutes(null, true);
            if (this.m_selectedMap == null) {
                return;
            }
            vwMapDef = this.m_selectedMap.getMapDefinition();
            if (vwMapDef == null) {
                return;
            }
            vwMapNodes = vwMapDef.getSteps();
            if (vwMapNodes == null) {
                return;
            }
            for (int i = 0; i < vwMapNodes.length; ++i) {
                vwMapNode = vwMapNodes[i];
                if (vwMapNode == null) continue;
                this.addRoutes(vwMapNode.getNextRoutes(), false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_bInitRouteData = false;
        }
    }

    private void addRoutes(VWRouteDefinition[] vwRouteDefs, boolean bClear) {
        DefaultComboBoxModel dataModel = null;
        try {
            if (this.m_nameComboBox == null) {
                return;
            }
            dataModel = (DefaultComboBoxModel)this.m_nameComboBox.getModel();
            if (dataModel == null) {
                return;
            }
            if (bClear && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            if (vwRouteDefs == null) {
                return;
            }
            Object route = null;
            for (int i = 0; i < vwRouteDefs.length; ++i) {
                String routeName = VWRouteListCellRenderer.toString(vwRouteDefs[i]);
                String name = null;
                boolean bInserted = false;
                for (int j = 0; j < dataModel.getSize(); ++j) {
                    name = VWRouteListCellRenderer.toString((VWRouteDefinition)dataModel.getElementAt(j));
                    if (VWStringUtils.compareIgnoreCase(routeName, name) >= 0) continue;
                    dataModel.insertElementAt(vwRouteDefs[i], j);
                    bInserted = true;
                    break;
                }
                if (bInserted) continue;
                dataModel.addElement(vwRouteDefs[i]);
            }
            if (this.m_nameComboBox.getItemCount() > 0) {
                this.m_nameComboBox.setEnabled(true);
                this.setSelectedIndexNoNotify(0);
            } else {
                this.m_nameComboBox.setEnabled(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateLayout() {
        if (this.m_selectedRoute == null) {
            this.setSelectedIndexNoNotify(-1);
            this.m_expressionTextArea.setText("");
        } else {
            this.setSelectedItemNoNotify(this.m_selectedRoute);
            try {
                String routeCondition = this.m_selectedRoute.getCondition();
                if (routeCondition == null) {
                    routeCondition = VWResource.s_true;
                }
                String conditionString = this.m_selectedRoute.getDestinationStep().getName();
                conditionString = conditionString + "\n   ";
                conditionString = conditionString + routeCondition;
                if (this.m_expressionTextArea != null) {
                    this.m_expressionTextArea.setText(conditionString);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void selectRoute(VWRouteDefinition route, boolean bNotify) {
        this.m_selectedRoute = route;
        this.updateLayout();
        if (bNotify) {
            this.notifySelectListeners();
        }
    }

    private void notifySelectListeners() {
        ItemEvent event = new ItemEvent(this, 0, this, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    private void setSelectedItemNoNotify(Object anObject) {
        this.m_bNotify = false;
        this.m_nameComboBox.setSelectedItem(anObject);
        this.m_bNotify = true;
    }

    private void setSelectedIndexNoNotify(int anIndex) {
        this.m_bNotify = false;
        this.m_nameComboBox.setSelectedIndex(anIndex);
        this.m_bNotify = true;
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        this.m_selectedRoute = null;
        if (this.m_selectedRoutes != null) {
            this.m_selectedRoutes.removeAllElements();
            this.m_selectedRoutes = null;
        }
        this.m_nameComboBox = null;
        this.m_routeListCellRenderer = null;
        this.m_expressionTextArea = null;
        this.m_selectListeners = null;
    }
}

